define([
    'jquery',
    'models/singleton-model',
], function($, Model) {
    'use strict';

    describe('Singleton Model', function() {
        var isSuccess;
        var responseData;

        beforeEach(function() {
            isSuccess = true;
            responseData = {};

            spyOn($, 'ajax').and.callFake(function() {
                var fake = new $.Deferred();
                var promise = fake.promise();
                promise.success = promise.then;
                promise.error = promise.fail;

                if (isSuccess) {
                    fake.resolve(responseData);
                } else {
                    fake.reject(responseData);
                }
                return promise;
            });
        });

        it('sets up an empty deferred object', function() {
            var collection = new Model();
            expect(collection.isReady).toBeDefined();
            expect(collection.isReady.state()).toBe('pending');
        });

        it('pretends that isReady is an xhr with a success function', function(done) {
            var collection = new Model();
            var data = true;
            collection.isReady.error(function() {
                // Fail if this is called
                expect(false).toBeTruthy();
                done();
            });
            collection.isReady.success(function(hasArg) {
                expect(hasArg).toBeTruthy();
                done();
            });
            collection._isReady.resolve(data);
        });

        it('pretends that isReady is an xhr with a error function', function(done) {
            var collection = new Model();
            var data = true;
            collection.isReady.success(function() {
                // Fail if this is called
                expect(false).toBeTruthy();
                done();
            });
            collection.isReady.error(function(hasArg) {
                expect(hasArg).toBeTruthy();
                done();
            });
            collection._isReady.reject(data);
        });


        it('triggers success', function(done) {
            var collection = new Model();
            collection.resourceName = 'appointment-requests';
            collection.listenTo(collection, 'fetch:success', function() {
                // If this is not reached the test will time out
                done();
            });
            collection.fetch();
        });

        it('triggers error', function(done) {
            var collection = new Model();
            isSuccess = false;
            collection.resourceName = 'appointment-requests';
            collection.listenTo(collection, 'fetch:error', function() {
                // If this is not reached the test will time out
                done();
            });
            collection.fetch();
        });

        it('passes the xhr response to isReady success', function(done) {
            var collection = new Model();
            responseData = {it: {passed: true}};
            collection.resourceName = 'appointment-requests';
            collection.isReady.success(function(data) {
                expect(data.it.passed).toBeTruthy();
                done();
            });
            collection.fetch();
        });

        it('passes the xhr response to isReady success', function(done) {
            var collection = new Model();
            isSuccess = false;
            responseData = {it: {passed: true}};
            collection.resourceName = 'appointment-requests';
            collection.isReady.error(function(data) {
                expect(data.it.passed).toBeTruthy();
                done();
            });
            collection.fetch();
        });
    });
});
